<?php

namespace Digits\SocialLogin\Auths;

use DigitsSocialOAuth2;

class GithubAuth extends SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;
    private $settings;

    function __construct($settings, $social_info, $icon_only)
    {
        $this->settings = $settings;
        $this->client_id = esc_attr($settings['clientID']);
        $this->redirect_url = $social_info['redirect_uri'];
        $this->icon_only = $icon_only;


        parent::__construct();

    }

    public function get_url()
    {
        $query = [
            'client_id' => urlencode($this->client_id),
            'scope' => urlencode('read:user user:email'),
            'response_type' => 'code',
            'redirect_uri' => urlencode($this->redirect_url),
            'state' => wp_create_nonce('github_login'),
        ];
        $base_url = 'https://github.com/login/oauth/authorize';
        return add_query_arg($query, $base_url);
    }

    public function render()
    {
        $this->default_layout('digits_github_login', 'GitHub');

    }

    public function enqueue_scripts()
    {
    }

    public function process_token()
    {
    }

    public function process_oauth_token()
    {
        if (empty($_REQUEST['code'])) {
            $this->invalid_info();
            die();
        }
        if (!wp_verify_nonce($_REQUEST['state'], 'github_login')) {
            $this->nonce_fail();
            die();
        }
        try {
            $userAgent = $this->settings['appName'];
            $code = $_REQUEST['code'];
            $accessTokenUrl = 'https://github.com/login/oauth/access_token';

            $client = new DigitsSocialOAuth2\Client($this->client_id, $this->settings['clientSecretID'], DigitsSocialOAuth2\Client::AUTH_TYPE_FORM);

            $client->setCurlOption(CURLOPT_USERAGENT, $userAgent);

            $params = array('code' => $code, 'redirect_uri' => $this->redirect_url);
            $response = $client->getAccessToken($accessTokenUrl, "authorization_code", $params);

            $accessTokenResult = [];
            parse_str($response['result'], $accessTokenResult);

            if (empty($accessTokenResult["access_token"])) {
                $this->invalid_info();
                die();
            }

            $client->setAccessToken($accessTokenResult["access_token"]);
            $client->setAccessTokenType(DigitsSocialOAuth2\Client::ACCESS_TOKEN_KEY);


            $response = $client->fetch("https://api.github.com/user");

            $response = $response['result'];

            $id = $response['id'];
            $username = $response['login'];
            $name = $response['login'];

            $email_response = $client->fetch("https://api.github.com/user/emails");
            $response = $email_response['result'];
            $email = $response[0]['email'];


            $response = digits_social_create_user($name, $email, 'github', $username, $id);

            $this->success_view($response);
        } catch (\Exception $e) {
            $this->error_view($e);
        }
    }
}
